package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class StaticBlockPaletteObject extends PaletteObject {
	
	private char blockChar;
	
	
	private boolean isNewButton;
	private boolean isEditButton;
	private boolean isCloneButton;
	private boolean isNewHurtzoneButton;
	
	public StaticBlockPaletteObject(IntRect theClickRect, char theBlockChar, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel thePanel) {
		
		blockChar = theBlockChar;
		clickRect = theClickRect;
		isSelected = false;
		editorPanel = thePanel;
		
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
	}




	public IntRect getClickRect() {
		return clickRect;
	}




	public char getBlockChar() {
		return blockChar;
	}
	
	
	

	
	public boolean isNewButton() {
		return isNewButton;
	}
	
	public boolean isEditButton() {
		return isEditButton;
	}


	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		if(image == null) {
			StaticBlockCanvasObject canvasObj = editorPanel.getCharactersToBlocks().get(blockChar);
			if(canvasObj == null || canvasObj.getImage() == null)
				return;
			
			canvasObj.getImage().drawObjectIgnoreBounds(g, p.x, p.y);
		} else {
			image.drawObjectIgnoreBounds(g, p.x, p.y);
		}
		
		Color origCol = g.getColor();
		
		if(isNewButton || isEditButton || isNewHurtzoneButton) {
			g.setColor(new Color(100, 100, 200));
		} else if(isSelected) {
			
			g.setColor(new Color(255, 200, 0));
			
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
		
	}
	
	
	

	public StaticBlockPaletteObject(IntRect theClickRect, char theBlockChar, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel thePanel, CustomImageDataII theImage, boolean newButton, boolean editButton) {
		
		blockChar = theBlockChar;
		clickRect = theClickRect;
		isSelected = false;
		editorPanel = thePanel;
		
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		isNewButton = newButton;
		isEditButton = editButton;
		
		image = theImage;
		
	}




	public boolean isCloneButton() {
		return isCloneButton;
	}




	public void setCloneButton(boolean isCloneButton) {
		this.isCloneButton = isCloneButton;
	}




	public boolean isNewHurtzoneButton() {
		return isNewHurtzoneButton;
	}




	public void setNewHurtzoneButton(boolean isNewHurtzoneButton) {
		this.isNewHurtzoneButton = isNewHurtzoneButton;
	}
	
	
	
	
	
	
	
}
